/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureContainer;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public abstract class DecoratorFigure
extends AbstractFigure
implements FigureContainer,
Observer {
    protected Figure fComponent;
    private static final long serialVersionUID = 8993011151564573288L;
    private int decoratorFigureSerializedDataVersion = 1;

    public DecoratorFigure() {
    }

    public DecoratorFigure(Figure figure) {
        this.decorate(figure);
    }

    public synchronized void addObserver(Observer o) {
        this.fComponent.addObserver(o);
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.fComponent.basicDisplayBox(origin, corner);
    }

    protected void basicMoveBy(int x, int y) {
    }

    public boolean canConnect() {
        return this.fComponent.canConnect();
    }

    public Figure comp() {
        return this.fComponent;
    }

    public Locator connectedTextLocator(Figure text) {
        return this.fComponent.connectedTextLocator(text);
    }

    public Insets connectionInsets() {
        return this.fComponent.connectionInsets();
    }

    public Connector connectorAt(int x, int y) {
        return this.fComponent.connectorAt(x, y);
    }

    public void connectorVisibility(boolean isVisible) {
        this.fComponent.connectorVisibility(isVisible);
    }

    public boolean containsPoint(int x, int y) {
        return this.fComponent.containsPoint(x, y);
    }

    public synchronized int countObservers() {
        return this.fComponent.countObservers();
    }

    public FigureEnumeration decompose() {
        return this.fComponent.decompose();
    }

    public void decorate(Figure figure) {
        this.fComponent = figure;
        this.fComponent.setContainer(this);
        this.fComponent.addObserver(this);
    }

    public synchronized void deleteObserver(Observer o) {
        this.fComponent.deleteObserver(o);
    }

    public synchronized void deleteObservers() {
        this.fComponent.deleteObservers();
    }

    public Rectangle displayBox() {
        return this.fComponent.displayBox();
    }

    public void draw(Graphics g) {
        this.fComponent.draw(g);
    }

    public Drawing drawing() {
        if (this.container() != null) {
            return this.container().drawing();
        }
        return null;
    }

    public FigureEnumeration figures() {
        return this.fComponent.figures();
    }

    public Figure findFigureInside(int x, int y) {
        return this.fComponent.findFigureInside(x, y);
    }

    public void forceUpdate() {
        if (this.container() != null) {
            this.container().forceUpdate();
        }
    }

    public Object getAttribute(String name) {
        return this.fComponent.getAttribute(name);
    }

    public Vector handles() {
        return this.fComponent.handles();
    }

    public synchronized boolean hasChanged() {
        return this.fComponent.hasChanged();
    }

    public boolean includes(Figure figure) {
        return super.includes(figure) || this.fComponent.includes(figure);
    }

    public void invalidate(Rectangle rect) {
        if (this.container() != null) {
            this.container().invalidate(rect);
        }
    }

    public void moveBy(int x, int y) {
        this.fComponent.moveBy(x, y);
    }

    public void notifyObservers() {
        this.fComponent.notifyObservers();
    }

    public synchronized void notifyObservers(Object arg) {
        this.fComponent.notifyObservers(arg);
    }

    public Figure peelDecoration() {
        this.fComponent.deleteObserver(this);
        this.fComponent.setContainer(null);
        return this.fComponent;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.decorate((Figure)dr.readStorable());
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.fComponent.setContainer(this);
        this.fComponent.addObserver(this);
    }

    public void release() {
        super.release();
        this.fComponent.deleteObserver(this);
        this.fComponent.release();
    }

    public Figure removeFromDrawing(Figure figure) {
        if (this.container() != null) {
            return this.container().removeFromDrawing(this);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        this.fComponent.setAttribute(name, value);
    }

    public void setContainer(FigureContainer container) {
        super.setContainer(container);
        this.fComponent.setContainer(this);
    }

    public void update(Observable o, Object arg) {
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fComponent);
    }
}

